/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class DrawnRenderer<T extends AbstractDrawnEntity, M extends EntityModel<T>>
extends EntityRenderer<T> {
    protected M model;
    private static final Field CHILD_MODELS = ObfuscationReflectionHelper.findField(ModelRenderer.class, (String)"field_78805_m");

    protected DrawnRenderer(EntityRendererManager renderManager, M model) {
        super(renderManager);
        this.model = model;
    }

    public void render(T entity, float yaw, float delta, MatrixStack stack, IRenderTypeBuffer source, int packedLight) {
        stack.func_227860_a_();
        AbstractDrawnEntity.RenderInfo info = ((AbstractDrawnEntity)((Object)entity)).getInfo(delta);
        this.setupRotation(entity, info.getYaw(), delta, stack);
        this.model.func_225597_a_(entity, delta, 0.0f, 0.0f, 0.0f, info.getPitch());
        IVertexBuilder buf = source.getBuffer(this.model.func_228282_a_(this.func_110775_a((Entity)entity)));
        this.model.func_225598_a_(stack, buf, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.renderContents(entity, delta, stack, source, packedLight);
        stack.func_227865_b_();
        super.func_225623_a_(entity, info.getYaw(), delta, stack, source, packedLight);
    }

    protected void renderContents(T entity, float delta, MatrixStack stack, IRenderTypeBuffer source, int packedLight) {
    }

    public void setupRotation(T entity, float entityYaw, float delta, MatrixStack stack) {
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        float time = (float)((AbstractDrawnEntity)((Object)entity)).getTimeSinceHit() - delta;
        if (time > 0.0f) {
            double center = 1.2;
            stack.func_227861_a_(0.0, 1.2, 0.0);
            float damage = Math.max(((AbstractDrawnEntity)((Object)entity)).getDamageTaken() - delta, 0.0f);
            float angle = MathHelper.func_76126_a((float)time) * time * damage / 60.0f;
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle * (float)((AbstractDrawnEntity)((Object)entity)).getForwardDirection()));
            stack.func_227861_a_(0.0, -1.2, 0.0);
            stack.func_227861_a_(0.0, (double)(angle / 32.0f), 0.0);
        }
        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
    }

    protected void attach(ModelRenderer bone, ModelRenderer attachment, Consumer<MatrixStack> function, MatrixStack stack) {
        stack.func_227860_a_();
        bone.func_228307_a_(stack);
        if (bone == attachment) {
            function.accept(stack);
        } else {
            ObjectList childModels;
            try {
                childModels = (ObjectList)CHILD_MODELS.get(bone);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            for (ModelRenderer child : childModels) {
                this.attach(child, attachment, function, stack);
            }
        }
        stack.func_227865_b_();
    }
}

